/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easy_villagers.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.easy_villagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class IronFarmTileentity
extends VillagerTileentity
implements ITickableBlockEntity {
    private static final ResourceLocation GOLEM_LOOT_TABLE = new ResourceLocation("entities/iron_golem");
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private long timer;
    private IItemHandlerModifiable handler;

    public IronFarmTileentity(BlockPos pos, BlockState state) {
        super(ModTileEntities.IRON_FARM, ModBlocks.IRON_FARM.m_49966_(), pos, state);
    }

    public long getTimer() {
        return this.timer;
    }

    @Override
    public void tick() {
        EasyVillagerEntity v = this.getVillagerEntity();
        if (v != null) {
            VillagerBlockBase.playRandomVillagerSound(this.f_58857_, this.m_58899_(), SoundEvents.f_12503_);
            VillagerBlockBase.playRandomVillagerSound(this.f_58857_, this.m_58899_(), SoundEvents.f_12598_);
            if (this.advanceAge()) {
                this.sync();
            }
            ++this.timer;
            this.m_6596_();
            if (this.timer == (long)IronFarmTileentity.getGolemSpawnTime()) {
                VillagerBlockBase.playVillagerSound(this.f_58857_, this.m_58899_(), SoundEvents.f_12598_);
                this.sync();
            } else if (this.timer > (long)IronFarmTileentity.getGolemSpawnTime() && this.timer < (long)IronFarmTileentity.getGolemKillTime()) {
                if (this.timer % 20L == 0L) {
                    VillagerBlockBase.playVillagerSound(this.f_58857_, this.m_58899_(), SoundEvents.f_12008_);
                }
            } else if (this.timer >= (long)IronFarmTileentity.getGolemKillTime()) {
                VillagerBlockBase.playVillagerSound(this.f_58857_, this.m_58899_(), SoundEvents.f_12059_);
                IItemHandlerModifiable itemHandler = this.getItemHandler();
                for (ItemStack drop : this.getDrops()) {
                    for (int i = 0; i < itemHandler.getSlots() && !(drop = itemHandler.insertItem(i, drop, false)).m_41619_(); ++i) {
                    }
                }
                this.timer = 0L;
                this.sync();
            }
        }
    }

    private List<ItemStack> getDrops() {
        if (!(this.f_58857_ instanceof ServerLevel)) {
            return Collections.emptyList();
        }
        ServerLevel serverWorld = (ServerLevel)this.f_58857_;
        LootContext.Builder builder = new LootContext.Builder(serverWorld).m_78977_(serverWorld.f_46441_).m_78972_(LootContextParams.f_81455_, (Object)new IronGolem(EntityType.f_20460_, this.f_58857_)).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_())).m_78972_(LootContextParams.f_81457_, (Object)DamageSource.f_19308_);
        LootContext lootContext = builder.m_78975_(LootContextParamSets.f_81415_);
        LootTable lootTable = serverWorld.m_142572_().m_129898_().m_79217_(GOLEM_LOOT_TABLE);
        return lootTable.m_79129_(lootContext);
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.inventory, () -> ((IronFarmTileentity)this).m_6596_());
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18976_((CompoundTag)compound, this.inventory, (boolean)false);
        compound.m_128356_("Timer", this.timer);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        ContainerHelper.m_18980_((CompoundTag)compound, this.inventory);
        this.timer = compound.m_128454_("Timer");
        super.m_142466_(compound);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(this::getItemHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public IItemHandlerModifiable getItemHandler() {
        if (this.handler == null) {
            this.handler = new ItemStackHandler(this.inventory);
        }
        return this.handler;
    }

    public static int getGolemSpawnTime() {
        return (Integer)Main.SERVER_CONFIG.golemSpawnTime.get() - 200;
    }

    public static int getGolemKillTime() {
        return IronFarmTileentity.getGolemSpawnTime() + 200;
    }
}

